package furny.swing.admin;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import furny.util.LoggerUtil;

/**
 * Main class of the furniture db admin.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public final class FurnDBAdminTool {

  /**
   * Instantiation is not necessary.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  private FurnDBAdminTool() {
  }

  /**
   * Main method to start the admin tool.
   * 
   * @param args
   *          Arguments are not required.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public static void main(final String[] args) {
    start();
  }

  /**
   * Starts the furniture db admin tool.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public static void start() {
    LoggerUtil.installLogger();

    SwingUtilities.invokeLater(new Runnable() {
      @Override
      public void run() {
        // try {
        // UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        // } catch (final Exception e) {
        // LOGGER.log(Level.WARNING, "An error occured", e);
        // }

        final JFrame frame = new FurnDBAdminFrame();
        frame.setVisible(true);
      }
    });
  }
}
